% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PurpleAirSoH_dailyABFit.R
\name{PurpleAirSoH_dailyABFit}
\alias{PurpleAirSoH_dailyABFit}
\title{Daily linear model fit values}
\usage{
PurpleAirSoH_dailyABFit(pat = NULL)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}
}
\description{
This function calculates daily linear model values between
the \code{pm25_A} and \code{pm25_B} channels. A daily r-squared value is
returned in addition to the coefficients of the linear fit (slope and 
intercept)
}
\examples{
 
library(AirSensor)

tbl <- 
  example_pat_failure_A \%>\%
  PurpleAirSoH_dailyABFit() 
  
names(tbl)
  
timeseriesTbl_multiPlot(
  tbl, 
  parameters = c("pm25_A_pm25_B_rsquared", "pm25_A_pm25_B_slope"),
  ylim = c(-1,1)
)

}
