% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_upgrade.R
\name{pas_upgrade}
\alias{pas_upgrade}
\title{Upgrade \emph{pa_synoptic} object format}
\usage{
pas_upgrade(pas = NULL, verbose = TRUE)
}
\arguments{
\item{pas}{A \emph{pa_synoptic} object.}

\item{verbose}{(logical) Display upgrade messages.}
}
\value{
\code{TRUE} if \code{pas} has the correct structure, \code{FALSE} otherwise.
}
\description{
The \code{pas} is checked for the latest pa_synoptic format
and presence of core metadata columns:
\itemize{
  \item{ID -- Purple Air ID}
  \item{label -- location label}
  \item{DEVICE_LOCATIONTYPE -- location descriptor}
  \item{THINGSPEAK_PRIMARY_ID -- Thingspeak API access ID}
  \item{THINGSPEAK_PRIMARY_ID_READ_KEY -- Thingspeak API access key}
  \item{THINGSPEAK_SECONDARY_ID -- Thingspeak API access ID}
  \item{THINGSPEAK_SECONDARY_ID_READ_KEY -- Thingspeak API access key}
  \item{longitude -- decimal degrees E}
  \item{latitude -- decimal degrees N}
  \item{pm25 -- latest PM25}
  \item{lasteSeenDate -- last update datetime}
  \item{sensorType -- PurpleAir sensor type}
  \item{flag_hidden -- hidden flag}
  \item{isOwner -- owner logical}
  \item{humidity -- \%}
  \item{temperature -- deg F}
  \item{pressure -- mb}
  \item{age -- sensor age}
  \item{parentID -- device parent ID}
  \item{timezone -- Olson timezone}
  \item{flag_highValue -- out of spec flag}
  \item{flag_attenutation_hardware -- hardware failure flag}
  \item{Ozone1 -- latest ozone data}
  \item{pm25_current -- current PM2.5 data}
  \item{pm25_10min -- 10-minute average PM2.5 data}
  \item{pm25_30min -- 30-minute average PM2.5 data}
  \item{pm25_1hr -- 1-hour average PM2.5 data}
  \item{pm25_6hr -- 6-hour average PM2.5 data}
  \item{pm25_1day -- 1-day PM2.5 average data}
  \item{pm25_1week -- 1-week PM2.5 average data}
  \item{statsLastModifiedDate -- last modified date}
  \item{statsLastModifiedInterval -- interval between modified date}
  \item{deviceID -- unique device identifier}
  \item{locationID -- generated location ID}
  \item{deviveDeploymentID -- generated unique ID}
  \item{countryCode -- ISO 3166-1 alpha-2}
  \item{stateCode -- ISO 3166-2 alpha-2}
  \item{timezone -- location timezone}
  \item{airDistrict -- Air district, if any}
  \item{pwfsl_closestDistance -- nearest regulatory monitor distance, meters}
  \item{pwfsl_closestMonitorID -- nearest regularoty monitor ID}
  \item{sensorManufacturer -- hardware manufacturer}
  \item{targetPollutant -- target pollutant data}
  \item{technologyType -- type of sensor technology}
  \item{communityRegion -- defined regional community.}
}
}
\examples{
\donttest{
library(AirSensor)

# Initialize the required spatial utilities
initializeMazamaSpatialUtils()

# Use outdated pa_synoptic database
setArchiveBaseUrl('http://smoke.mazamascience.com/data/PurpleAir')

pas <- 
  pas_load() \%>\%
  pas_upgrade()
} 
}
\keyword{pas}
