% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_staticMap.R
\name{pas_staticMap}
\alias{pas_staticMap}
\title{Static map of PurpleAir sensors}
\usage{
pas_staticMap(
  pas = NULL,
  parameter = "pm25_1hr",
  paletteName = "Purples",
  mapTheme = "terrain",
  mapShape = "sq",
  direction = 1,
  minScale = 0,
  maxScale = 150,
  shape = 15,
  size = 2,
  alpha = 0.8,
  bbuff = 0.5,
  zoomAdjust = 0,
  ...
)
}
\arguments{
\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{parameter}{Value to plot, e.g. \code{pm25_1hr}.}

\item{paletteName}{Base color or palette name to be used.}

\item{mapTheme}{Default is "terrain", see description for additional options.}

\item{mapShape}{Default is "square", can also be "natural".}

\item{direction}{Legend color direction.}

\item{minScale}{Minimum value to set scale for color gradient. Default is 0.}

\item{maxScale}{Maximum value to set scale for color gradient. Default is 150.}

\item{shape}{Symbol to use for points.}

\item{size}{Size of points.}

\item{alpha}{Opacity of points.}

\item{bbuff}{Bounding box buffer. Default is 0.1.}

\item{zoomAdjust}{Adjustment to map zoom level (-1:3).}

\item{...}{Additional options: the legend can disabled \code{guide = FALSE}, 
and renamed with \code{name= "Example name"}.}
}
\value{
A ggplot object.
}
\description{
Creates a static map of a \emph{pas} object

Users can create a map using any numeric data column within the
\emph{pas} object:

\code{"pm25" "temperature" "humidity" "pressure" 
 "pm25_current" "pm25_10min" "pm25_30min" "pm25_1hr" "pm25_6hr" 
 "pm25_1day" "pm25_1week" "pwfsl_closestDistance"}

Available \code{paletteName} options include an \code{"AQI"} color palette, 
as well as a suite of sequential and diverging palettes from the 
\pkg{RColorBrewer} R package.

The sequential palette names are
 
\code{"Blues" "BuGn" "BuPu" "GnBu" "Greens" "Greys" "Oranges" "OrRd" "PuBu" 
 "PuBuGn" "PuRd" "Purples" "RdPu" "Reds" "YlGn" "YlGnBu" "YlOrBr" "YlOrRd"}

The diverging palette names are 

\code{"BrBG" "PiYG" "PRGn" "PuOr" "RdBu" "RdGy" "RdYlBu" "RdYlGn" "Spectral"}

Additional map tile info found at:
\url{http://maps.stamen.com/}
}
\examples{
library(AirSensor)

LA_basin <- 
  example_pas \%>\% 
  pas_filterArea(-118.5, -117.5, 33.5, 34.5)
pas_staticMap(LA_basin, paletteName = "AQI", zoomAdjust = 1)
}
\keyword{pa_synoptic}
