% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_filter.R
\name{pas_filter}
\alias{pas_filter}
\title{General purpose filtering for PurpleAir Synoptic objects}
\usage{
pas_filter(pas, ...)
}
\arguments{
\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{...}{Logical predicates defined in terms of the variables in the 
\code{pas}. Multiple conditions are combined with & or seperated by a comma. 
Only rows where the condition evaluates to TRUE are kept.}
}
\value{
A subset of the given \emph{pas} object.
}
\description{
A generalized data filter for \emph{pas} objects to 
  choose rows/cases where conditions are true. Rows where the condition 
  evaluates to NA are dropped.
}
\examples{
library(AirSensor)

nrow(example_pas)

# California
ca <- pas_filter(example_pas, stateCode == "CA")
nrow(ca)

# Seal Beach
scsb <- 
  ca \%>\%
  pas_filter(stringr::str_detect(label, "^SCSB_"))
nrow(scsb)

if ( interactive() ) {
  pas_leaflet(ca)

  pas_leaflet(scsb, maptype = "satellite")
}

}
\seealso{
\link{pas_filterArea}, \link{pas_filterNear}
}
