% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_createNew.R
\name{pas_createNew}
\alias{pas_createNew}
\title{Load latest PurpleAir synoptic data}
\usage{
pas_createNew(
  countryCodes = NULL,
  includePWFSL = TRUE,
  lookbackDays = 1,
  baseUrl = "https://www.purpleair.com/json"
)
}
\arguments{
\item{countryCodes}{ISO country codes used to subset the data.}

\item{includePWFSL}{Logical specifying whether to calculate distances from 
PWFSL monitors.}

\item{lookbackDays}{Number of days to "look back" for valid data. Data are
filtered to only include sensors with data more recent than 
\code{lookbackDays} ago.}

\item{baseUrl}{Base URL for synoptic data.}
}
\value{
A PurpleAir Synoptic \emph{pas} object.
}
\description{
Download, parse and enhance synoptic data from PurpleAir and
return the results as a useful tibble with class \code{pa_synoptic}.

Steps include:

1) Download and parse synoptic data

2) Replace variable with more consistent, more human readable names.

3) Add spatial metadata for each sensor including:
\itemize{
  \item{timezone -- olson timezone}
  \item{countryCode -- ISO 3166-1 alpha-2}
  \item{stateCode -- ISO 3166-2 alpha-2}
}

4) Convert data types from character to \code{POSIXct} and \code{numeric}.

5) Add distance and monitorID for the closest PWFSL monitor

Filtering by country may be performed by specifying the \code{countryCodes}
argument.
}
\examples{
\donttest{
library(AirSensor)

initializeMazamaSpatialUtils()

pas <- pas_createNew("US")

if ( interactive() ) {
  pas \%>\% 
    pas_filter(stateCode == "CA") \%>\%
    pas_leaflet()
}
}
}
\seealso{
\link{pas_load}

\link{pas_downloadParseRawData}
}
