% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patData_aggregate.R
\name{patData_aggregate}
\alias{patData_aggregate}
\title{Aggregate PurpleAir Timeseries Data}
\usage{
patData_aggregate(
  df,
  FUN = function(df) {     mean(df$pm25_A + df$pm25_B, na.rm = TRUE) },
  unit = "minutes",
  count = 60
)
}
\arguments{
\item{df}{Timeseries \emph{pat} data, or timeseries data.frame with valid
\emph{datetime} column.}

\item{FUN}{The function to be applied to each vector of numeric \code{df}.}

\item{unit}{Character string specifying temporal units for binning.}

\item{count}{Number of units per bin.}
}
\value{
Returns an aggregated \emph{data.frame} object.
}
\description{
Aggregate a dataframe into temporal bins and apply a function.
Temporal aggregation involves splitting a dataframe into separate bins along
its \code{datetime} axis. \code{FUN} is mapped to the \code{df}
dataframe records in each bin which are then recombined into an aggregated
dataframe.
}
\details{
This function is intended for advanced users who wish to have more
flexibility than the standard \emph{pat_aggregate()} while aggregating
timeseries data. \code{FUN} can operate and access all numeric vectors
within the data frame \code{df} and must return a matrix or tibble of numeric 
values. Any errors generated during application of \code{FUN} on subsets
of \code{df} must be handled as in the example.
}
\examples{
library(AirSensor)

# Single day subset
pat <-
  example_pat \%>\%
  pat_filterDate(20180813, 20180814)

# Two Sample Student T-Test (advanced users only - see details.)
FUN_ttest <- function(x) {
  result <- try({
    hourly_ttest <- stats::t.test(x$pm25_A, x$pm25_B, paired = FALSE)
    tbl <- dplyr::tibble(
      t_score = as.numeric(hourly_ttest$statistic),
      p_value = as.numeric(hourly_ttest$p.value),
      df_value = as.numeric(hourly_ttest$parameter)
    )
  }, silent = TRUE)
  if ( "try-error" \%in\% class(result) ) {
    tbl <- dplyr::tibble(
      t_score = as.numeric(NA),
      p_value = as.numeric(NA),
      df_value = as.numeric(NA)
    )
  }
  return(tbl)
}

t.testStats <-
  pat \%>\%
  pat_extractData() \%>\% # Note: Extract the timeseries data.frame
  patData_aggregate(FUN_ttest)
  
head(t.testStats)
}
\keyword{pa_timeseries}
