% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc2fat_function.R
\name{desc2fat}
\alias{desc2fat}
\title{Descriptive: Descriptive analysis (Two factors)}
\usage{
desc2fat(f1, f2, response, ylab = "Response", theme = theme_classic())
}
\arguments{
\item{f1}{Numeric or complex vector with factor 1 levels}

\item{f2}{Numeric or complex vector with factor 2 levels}

\item{response}{Numerical vector containing the response of the experiment.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}
}
\value{
The function returns exploratory measures of position and dispersion, such as mean, median, maximum, minimum, coefficient of variation, etc ...
}
\description{
It performs the descriptive analysis of an experiment with two factors of interest.
}
\examples{
library(AgroR)
data(cloro)
with(cloro, desc2fat(f1,f2,resp))
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Descriptive}
\keyword{Experimental}
