% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{compute.event.int.gaps}
\alias{compute.event.int.gaps}
\title{Gap Days and Event (prescribing or dispensing) Intervals.}
\usage{
compute.event.int.gaps(
  data,
  ID.colname = NA,
  event.date.colname = NA,
  event.duration.colname = NA,
  event.daily.dose.colname = NA,
  medication.class.colname = NA,
  event.interval.colname = "event.interval",
  gap.days.colname = "gap.days",
  carryover.within.obs.window = FALSE,
  carryover.into.obs.window = FALSE,
  carry.only.for.same.medication = FALSE,
  consider.dosage.change = FALSE,
  followup.window.start = 0,
  followup.window.start.unit = c("days", "weeks", "months", "years")[1],
  followup.window.duration = 365 * 2,
  followup.window.duration.unit = c("days", "weeks", "months", "years")[1],
  observation.window.start = 0,
  observation.window.start.unit = c("days", "weeks", "months", "years")[1],
  observation.window.duration = 365 * 2,
  observation.window.duration.unit = c("days", "weeks", "months", "years")[1],
  date.format = "\%m/\%d/\%Y",
  keep.window.start.end.dates = FALSE,
  remove.events.outside.followup.window = TRUE,
  keep.event.interval.for.all.events = FALSE,
  parallel.backend = c("none", "multicore", "snow", "snow(SOCK)", "snow(MPI)",
    "snow(NWS)")[1],
  parallel.threads = "auto",
  suppress.warnings = FALSE,
  return.data.table = FALSE,
  ...
)
}
\arguments{
\item{data}{A \emph{\code{data.frame}} containing the events used to
compute the CMA. Must contain, at a minimum, the patient unique ID, the event
date and duration, and might also contain the daily dosage and medication
type (the actual column names are defined in the following four parameters);
the \code{CMA} constructors call this parameter \code{data}.}

\item{ID.colname}{A \emph{string}, the name of the column in \code{data}
containing the unique patient ID; must be present.}

\item{event.date.colname}{A \emph{string}, the name of the column in
\code{data} containing the start date of the event (in the format given in
the \code{date.format} parameter); must be present.}

\item{event.duration.colname}{A \emph{string}, the name of the column in
\code{data} containing the event duration (in days); must be present.}

\item{event.daily.dose.colname}{A \emph{string}, the name of the column in
\code{data} containing the prescribed daily dose, or \code{NA} if not defined.}

\item{medication.class.colname}{A \emph{string}, the name of the column in
\code{data} containing the classes/types/groups of medication, or \code{NA}
if not defined.}

\item{event.interval.colname}{A \emph{string}, the name of a newly-created
column storing the number of days between the start of the current event and
the start of the next one; the default value "event.interval" should be
changed only if there is a naming conflict with a pre-existing
"event.interval" column in \code{event.info}.}

\item{gap.days.colname}{A \emph{string}, the name of a newly-created column
storing the number of days when medication was not available (i.e., the
"gap days"); the default value "gap.days" should be changed only if there is
a naming conflict with a pre-existing "gap.days" column in \code{event.info}.}

\item{carryover.within.obs.window}{\emph{Logical}, if \code{TRUE} consider
the carry-over within the observation window, or \code{NA} if not defined.}

\item{carryover.into.obs.window}{\emph{Logical}, if \code{TRUE} consider the
carry-over from before the starting date of the observation window, or
\code{NA} if not defined.}

\item{carry.only.for.same.medication}{\emph{Logical}, if \code{TRUE} the
carry-over applies only across medication of the same type, or \code{NA}
if not defined.}

\item{consider.dosage.change}{\emph{Logical}, if \code{TRUE} the carry-over
is adjusted to reflect changes in dosage, or \code{NA} if not defined.}

\item{followup.window.start}{If a \emph{\code{Date}} object, it represents
the actual start date of the follow-up window; if a \emph{string} it is the
name of the column in \code{data} containing the start date of the follow-up
window either as the numbers of \code{followup.window.start.unit} units after
the first event (the column must be of type \code{numeric}) or as actual
dates (in which case the column must be of type \code{Date}); if a
\emph{number} it is the number of time units defined in the
\code{followup.window.start.unit} parameter after the begin of the
participant's first event.}

\item{followup.window.start.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.start} refers to (when a number), or
\code{NA} if not defined.}

\item{followup.window.duration}{either a \emph{number} representing the
duration of the follow-up window in the time units given in
\code{followup.window.duration.unit}, or a \emph{string} giving the column
containing these numbers. Should represent a period for which relevant
medication events are recorded accurately (e.g. not extend after end of
relevant treatment, loss-to-follow-up or change to a health care provider
not covered by the database).}

\item{followup.window.duration.unit}{can be either \emph{"days"},
\emph{"weeks"}, \emph{"months"} or \emph{"years"}, and represents the time
units that \code{followup.window.duration} refers to, or \code{NA} if not
defined.}

\item{observation.window.start, observation.window.start.unit, observation.window.duration, observation.window.duration.unit}{the definition of the observation window
(see the follow-up window parameters above for details).}

\item{date.format}{A \emph{string} giving the format of the dates used in the
\code{data} and the other parameters; see the \code{format} parameters of the
\code{\link[base]{as.Date}} function for details (NB, this concerns only the
dates given as strings and not as \code{Date} objects).}

\item{keep.window.start.end.dates}{\emph{Logical}, should the computed start
and end dates of the windows be kept?}

\item{remove.events.outside.followup.window}{\emph{Logical}, should the
events that fall outside the follo-wup window be removed from the results?}

\item{keep.event.interval.for.all.events}{\emph{Logical}, should the computed
event intervals be kept for all events, or \code{NA}'ed for those outside the
OW?}

\item{parallel.backend}{Can be "none" (the default) for single-threaded
execution, "multicore"  (using \code{mclapply} in package \code{parallel})
for multicore processing (NB. not currently implemented on MS Windows and
automatically falls back on "snow" on this platform),  or "snow",
"snow(SOCK)" (equivalent to "snow"), "snow(MPI)" or "snow(NWS)" specifying
various types of SNOW clusters (can be on the local machine or more complex
setups -- please see the documentation of package \code{snow} for details;
the last two require packages \code{Rmpi} and \code{nws}, respectively, not
automatically installed with \code{AdhereR}).}

\item{parallel.threads}{Can be "auto" (for \code{parallel.backend} ==
"multicore", defaults to the number of cores in the system as given by
\code{options("cores")}, while for \code{parallel.backend} == "snow",
defaults to 2), a strictly positive integer specifying the number of parallel
threads, or a more complex specification of the SNOW cluster nodes for
\code{parallel.backend} == "snow" (see the documentation of package
\code{snow} for details).}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}

\item{return.data.table}{\emph{Logical}, if \code{TRUE} return a
\code{data.table} object, otherwise a \code{data.frame}.}

\item{...}{extra arguments.}
}
\value{
A \code{data.frame} or \code{data.table} extending the
\code{event.info} parameter with:
\itemize{
 \item \code{event.interval} Or any other name given in
 \code{event.interval.colname}, containing the number of days between the
 start of the current event and the start of the next one.
 \item \code{gap.days} Or any other name given in \code{gap.days.colname},
 containing the number of days when medication was not available for the
 current event (i.e., the "gap days").
 \item \code{.FU.START.DATE,.FU.END.DATE} if kept, the actual start and end
 dates of the follow-up window (after adjustments due to the various
 parameters).
 \item \code{.OBS.START.DATE,.OBS.END.DATE} if kept, the actual start and end
 dates of the observation window (after adjustments due to the various
 parameters).
 \item \code{.EVENT.STARTS.BEFORE.OBS.WINDOW} if kept, \code{TRUE} if the
 current event starts before the start of the observation window.
 \item \code{.TDIFF1,.TDIFF2} if kept, various auxiliary time differences
 (in days).
 \item \code{.EVENT.STARTS.AFTER.OBS.WINDOW} if kept, \code{TRUE} if the
 current event starts after the end of the observation window.
 \item \code{.CARRY.OVER.FROM.BEFORE} if kept, the carry-over (if any) from
 the previous events.
 \item \code{.EVENT.WITHIN.FU.WINDOW} if kept, \code{TRUE} if the current
 event is within the follow-up window.
}
}
\description{
For a given event (prescribing or dispensing) database, compute the gap days
and event intervals in various scenarious.
}
\details{
This should in general not be called directly by the user, but is provided as
a basis for the extension to new CMAs.
}
