% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{getCMA}
\alias{getCMA}
\title{Access the actual CMA estimate from a CMA object.}
\usage{
getCMA(x)
}
\arguments{
\item{x}{a CMA object.}
}
\value{
a \emph{data.frame} containing the CMA estimate(s).
}
\description{
Retreive the actual CMA estimate(s) encapsulated in a simple, per episode,
or sliding window CMA object.
}
\examples{
cma1 <- CMA1(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             followup.window.start=30,
             observation.window.start=30,
             observation.window.duration=365,
             date.format="\%m/\%d/\%Y"
            );
getCMA(cma1);
\dontrun{
cmaE <- CMA_per_episode(CMA="CMA1",
                        data=med.events,
                        ID.colname="PATIENT_ID",
                        event.date.colname="DATE",
                        event.duration.colname="DURATION",
                        event.daily.dose.colname="PERDAY",
                        medication.class.colname="CATEGORY",
                        carry.only.for.same.medication=FALSE,
                        consider.dosage.change=FALSE,
                        followup.window.start=0,
                        observation.window.start=0,
                        observation.window.duration=365,
                        date.format="\%m/\%d/\%Y"
                       );
getCMA(cmaE);}
}
