% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_p.r
\name{merge_p_values}
\alias{merge_p_values}
\title{Merge a list or matrix of p-values}
\usage{
merge_p_values(scores, method = "Fisher")
}
\arguments{
\item{scores}{Either a list of p-values or a matrix where each column is a test.}

\item{method}{Method to merge p-values. See 'methods' section below.}
}
\value{
If \code{scores} is a vector or list, returns a number. If \code{scores} is a
  matrix, returns a named list of p-values merged by row.
}
\description{
Merge a list or matrix of p-values
}
\section{Methods}{

Two methods are available to merge a list of p-values:
\describe{
 \item{Fisher}{Fisher's method (default) assumes that p-values are uniformly
 distributed and performs a chi-squared test on the statistic sum(-2 log(p)).
 This method is most appropriate when the columns in \code{scores} are
 independent.}
 \item{Brown}{Brown's method extends Fisher's method by accounting for the
 covariance in the columns of \code{scores}. It is more appropriate when the
 tests of significance used to create the columns in \code{scores} are not
 necessarily independent. Note that the "Brown" method cannot be used with a 
 single list of p-values. However, in this case Brown's method is identical 
 to Fisher's method and should be used instead.}
}
}

\examples{
  merge_p_values(c(0.05, 0.09, 0.01))
  merge_p_values(list(a=0.01, b=1, c=0.0015, d=0.025), method='Fisher')
  merge_p_values(matrix(data=c(0.03, 0.061, 0.48, 0.052), nrow = 2), method='Brown')

}
