% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActivePathways.r
\name{ActivePathways}
\alias{ActivePathways}
\title{ActivePathways}
\usage{
ActivePathways(
  scores,
  gmt,
  background = makeBackground(gmt),
  geneset.filter = c(5, 1000),
  cutoff = 0.1,
  significant = 0.05,
  merge.method = c("Brown", "Fisher"),
  correction.method = c("holm", "fdr", "hochberg", "hommel", "bonferroni", "BH", "BY",
    "none"),
  cytoscape.file.tag = NA
)
}
\arguments{
\item{scores}{A numerical matrix of p-values where each row is a gene and
each column represents an omics dataset (evidence). Rownames correspond to the genes 
and colnames to the datasets. All values must be 0<=p<=1. We recommend converting 
missing values to ones.}

\item{gmt}{A GMT object to be used for enrichment analysis. If a filename, a
GMT object will be read from the file.}

\item{background}{A character vector of gene names to be used as a
statistical background. By default, the background is all genes that appear
in \code{gmt}.}

\item{geneset.filter}{A numeric vector of length two giving the lower and 
upper limits for the size of the annotated geneset to pathways in gmt.
Pathways with a geneset shorter than \code{geneset.filter[1]} or longer
than \code{geneset.filter[2]} will be removed. Set either value to NA to
to not enforce a minimum or maximum value, or set \code{geneset.filter} to 
\code{NULL} to skip filtering.}

\item{cutoff}{A maximum merged p-value for a gene to be used for analysis.
Any genes with merged, unadjusted \code{p > significant} will be discarded 
before testing.}

\item{significant}{Significance cutoff for selecting enriched pathways. Pathways with
\code{adjusted.p.val < significant} will be selected as results.}

\item{merge.method}{Statistical method to merge p-values. See section on Merging P-Values}

\item{correction.method}{Statistical method to correct p-values. See
\code{\link[stats]{p.adjust}} for details.}

\item{cytoscape.file.tag}{The directory and/or file prefix to which the output files
for generating enrichment maps should be written. If NA, files will not be written.}
}
\value{
A data.table of terms (enriched pathways) containing the following columns:
  \describe{
    \item{term.id}{The database ID of the term}
    \item{term.name}{The full name of the term}
    \item{adjusted.p.val}{The associated p-value, adjusted for multiple testing}
    \item{term.size}{The number of genes annotated to the term}
    \item{overlap}{A character vector of the genes enriched in the term}
    \item{evidence}{Columns of \code{scores} (i.e., omics datasets) that contributed 
         individually to the enrichment of the term. Each input column is evaluated 
         separately for enrichments and added to the evidence if the term is found.}
  }
}
\description{
ActivePathways
}
\section{Merging P-values}{

To obtain a single p-value for each gene across the multiple omics datasets considered, 
the p-values in \code{scores} #' are merged row-wise using a data fusion approach of p-value merging. 
The two available methods are:
\describe{
 \item{Fisher}{Fisher's method assumes p-values are uniformly
 distributed and performs a chi-squared test on the statistic sum(-2 log(p)).
 This method is most appropriate when the columns in \code{scores} are
 independent.}
 \item{Brown}{Brown's method extends Fisher's method by accounting for the
 covariance in the columns of \code{scores}. It is more appropriate when the
 tests of significance used to create the columns in \code{scores} are not
 necessarily independent. The Brown's method is therefore recommended for 
 many omics integration approaches.}
}
}

\section{Cytoscape}{

  To visualize and interpret enriched pathways, ActivePathways provides an option
  to further analyse results as enrichment maps in the Cytoscape software. 
  If \code{!is.na(cytoscape.file.tag)}, four files will be written that can be used 
  to build enrichment maps. This requires the EnrichmentMap and enhancedGraphics apps.

The four files written are:
  \describe{
    \item{pathways.txt}{A list of significant terms and the
    associated p-value. Only terms with \code{adjusted.p.val <= significant} are
    written to this file.}
    \item{subgroups.txt}{A matrix indicating whether the significant terms (pathways)
    were also found to be significant when considering only one column from
    \code{scores}. A one indicates that that term was found to be significant 
			when only p-values in that column were used to select genes.}
    \item{pathways.gmt}{A Shortened version of the supplied GMT
    file, containing only the significantly enriched terms in pathways.txt. }
    \item{legend.pdf}{A legend with colours matching contributions
    from columns in \code{scores}.}
  }

  How to use: Create an enrichment map in Cytoscape with the file of terms
  (pathways.txt) and the shortened gmt file
  (pathways.gmt). Upload the subgroups file (subgroups.txt) as a table
  using the menu File > Import > Table from File. To paint nodes according 
  to the type of supporting evidence, use the 'style'
  panel, set image/Chart1 to use the column `instruct` and the passthrough
  mapping type. Make sure the app enhancedGraphics is installed. 
  Lastly, use the file legend.pdf as a reference for colors in the enrichment map.
}

\examples{
    fname_scores <- system.file("extdata", "Adenocarcinoma_scores_subset.tsv", 
         package = "ActivePathways")
    fname_GMT = system.file("extdata", "hsapiens_REAC_subset.gmt",
         package = "ActivePathways")

    dat <- as.matrix(read.table(fname_scores, header = TRUE, row.names = 'Gene'))
    dat[is.na(dat)] <- 1

    ActivePathways(dat, fname_GMT)

}
