% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActExtendCosinor_long.R
\name{ActExtendCosinor_long}
\alias{ActExtendCosinor_long}
\title{Cosinor Model for Circadian Rhythmicity for the Whole Dataset}
\usage{
ActExtendCosinor_long(
  count.data,
  window = 1,
  lower = c(0, 0, -1, 0, -3),
  upper = c(Inf, Inf, 1, Inf, 27)
)
}
\arguments{
\item{count.data}{\code{data.frame} of dimension n * (p+2) containing the
p dimensional activity data for all n subject days.
The first two columns have to be ID and Day. ID can be
either \code{character} or \code{numeric}. Day has to be \code{numeric} indicating
the sequence of days within each subject.}

\item{window}{The calculation needs the window size of the data. E.g window = 1 means each epoch is in one-minute window.
window size as an argument.}

\item{lower}{A numeric vector of lower bounds on each of the five parameters (in the order of minimum, amplitude, alpha, beta, acrophase) for the NLS. If not given, the default lower bound for each parameter is set to \code{-Inf}.}

\item{upper}{A numeric vector of upper bounds on each of the five parameters (in the order of minimum, amplitude, alpha, beta, acrophase) for the NLS. If not given, the default lower bound for each parameter is set to \code{Inf}}
}
\value{
A \code{data.frame} with the following 5 columns
\item{ID}{ID}
\item{ndays}{number of days}
\item{minimum}{Minimum value of the of the function.}
\item{amp}{amplitude, a measure of half the extend of predictable variation within a cycle. This represents the highest activity one can achieve.}
\item{alpha}{It determines whether the peaks of the curve are wider than the troughs: when alpha is small, the troughs are narrow and the peaks are wide; when alpha is large, the troughs are wide and the peaks are narrow.}
\item{beta}{It dertermines whether the transformed function rises and falls more steeply than the cosine curve: large values of beta produce curves that are nearly square waves.}
\item{acrotime}{acrophase is the time of day of the peak in the unit of the time (hours)}
\item{F_pseudo}{Measure the improvement of the fit obtained by the non-linear estimation of the transformed cosine model}
\item{UpMesor}{Time of day of switch from low to high activity. Represents the timing of the rest- activity rhythm. Lower (earlier) values indicate increase in activity earlier in the day and suggest a more advanced circadian phase.}
\item{DownMesor}{Time of day of switch from high to low activity. Represents the timing of the rest-activity rhythm. Lower (earlier) values indicate decline in activity earlier in the day, suggesting a more advanced circadian phase.}
\item{MESOR}{A measure analogous to the MESOR of the cosine model (or half the deflection of the curve) can be obtained from mes=min+amp/2. However, it goes through the middle of the peak, and is therefore not equal to the MESOR of the cosine model, which is the mean of the data.}
}
\description{
Extended cosinor model based on sigmoidally transformed cosine curve using anti-logistic transformation.This function is a whole dataset
wrapper for \code{ActExtendCosinor}.
}
\examples{
counts_1 = example_activity_data$count[c(1:12),]
cos_all_1 = ActExtendCosinor_long(count.data = counts_1, window = 1)
counts_10 = cbind(counts_1[,1:2],
as.data.frame(t(apply(counts_1[,-c(1:2)], 1,
FUN = bin_data, window = 10, method = "average"))))
cos_all_10 = ActExtendCosinor_long(count.data = counts_10, window = 10)
}
