% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ssir_epidemic_multi.R
\name{summary.ssir_epidemic_multi}
\alias{summary.ssir_epidemic_multi}
\title{S3 Summary method for multiple epidemic simulations}
\usage{
\method{summary}{ssir_epidemic_multi}(object, ...)
}
\arguments{
\item{object}{An object of class "ssir_epidemic_multi", typically the result of
calling ssir() with rep > 1.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
No return value, called for side effects.
}
\description{
This function provides a summary of multiple SSIR epidemic simulations.
It calculates and displays average statistics across all simulations.
}
\examples{
# Run multiple simulations
multi_result <- ssir(N = 10000, T = 300, alpha = 0.3, inf_period = 4,
                     inf_init = 32, report = 0.02, lag = 7, rep = 100)

# Display summary
summary(multi_result)

}
