% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_SeasAttributes.R
\name{ATA.SeasAttr}
\alias{ATA.SeasAttr}
\title{Attributes Set For Unit Root and Seasonality Tests}
\usage{
ATA.SeasAttr(
  corrgram.tcrit = 1.28,
  uroot.test = "adf",
  suroot.test = "correlogram",
  suroot.uroot = TRUE,
  uroot.type = "level",
  uroot.alpha = 0.05,
  suroot.alpha = 0.05,
  uroot.maxd = 2,
  suroot.maxD = 1,
  suroot.m = NULL,
  uroot.pkg = "tseries",
  multi.period = "min",
  x13.estimate.maxiter = 1500,
  x13.estimate.tol = 1e-05,
  x11.estimate.maxiter = 1500,
  x11.estimate.tol = 1e-05
)
}
\arguments{
\item{corrgram.tcrit}{t-value for autocorrelogram.}

\item{uroot.test}{Type of unit root test before all type seasonality test. Possible values are "adf", "pp" and "kpss".}

\item{suroot.test}{Type of seasonal unit root test to use. Possible values are "correlogram", "seas", "hegy", "ch" and "ocsb".}

\item{suroot.uroot}{If TRUE, unit root test for stationary before seasonal unit root test is allowed.}

\item{uroot.type}{Specification of the deterministic component in the regression for unit root test. Possible values are "level" and "trend".}

\item{uroot.alpha}{Significant level of the unit root test, possible values range from 0.01 to 0.1.}

\item{suroot.alpha}{Significant level of the seasonal unit root test, possible values range from 0.01 to 0.1}

\item{uroot.maxd}{Maximum number of non-seasonal differences allowed.}

\item{suroot.maxD}{Maximum number of seasonal differences allowed.}

\item{suroot.m}{Deprecated. Length of seasonal period: frequency of data for nsdiffs.}

\item{uroot.pkg}{Using \code{urca} or \code{tseries} packages for unit root test. The default value is "urca".}

\item{multi.period}{Selection type of multi seasonal period. \code{min} or \code{max} function for selection}

\item{x13.estimate.maxiter}{Maximum iteration for X13ARIMA/SEATS estimation}

\item{x13.estimate.tol}{Convergence tolerence for X13ARIMA/SEATS estimation}

\item{x11.estimate.maxiter}{Maximum iteration for X11 estimation}

\item{x11.estimate.tol}{Convergence tolerence for X11 estimation}
}
\value{
An object of class \code{ataattrset}.
}
\description{
This function is a class of seasonality tests using  \code{corrgram.test} from ATAforecasting package, \code{ndiffs} and \code{nsdiffs} functions from forecast package.
Also, this function is modified version of \code{ndiffs} and \code{nsdiffs} written by Hyndman et al. \code{forecast} package.
Please review manual and vignette documents of latest \code{forecast} package. According to \code{forecast} package,
\code{ndiffs} and \code{nsdiffs} functions to estimate the number of differences required to make a given time series stationary.
\code{ndiffs} uses unit root tests to determine the number of differences required for time series to be made trend stationary. Several different tests are available:
\itemize{
	\item {uroot.test = 'kpss'}		: the KPSS test is used with the null hypothesis that \code{x} has a stationary root against a unit-root alternative. Then the test returns the least number of differences required to pass the test at the level \code{uroot.alpha}.
	\item {uroot.test = 'adf'}		: the Augmented Dickey-Fuller test is used.
	\item {uroot.test = 'pp'}		: the Phillips-Perron test is used. In both of these cases, the null hypothesis is that \code{x} has a unit root against a stationary root alternative. Then the test returns the least number of differences required to fail the test at the level \code{alpha}.
}
\code{nsdiffs} uses seasonal unit root tests to determine the number of seasonal differences required for time series to be made stationary. Several different tests are available:
\itemize{
	\item {suroot.test = 'seas'}		: a measure of seasonal strength is used, where differencing is selected if the seasonal strength (Wang, Smith & Hyndman, 2006) exceeds 0.64 (based on minimizing MASE when forecasting using auto.arima on M3 and M4 data).
	\item {suroot.test = 'ch'}			: the Canova-Hansen (1995) test is used (with null hypothesis of deterministic seasonality)
	\item {suroot.test = 'hegy'}		: the Hylleberg, Engle, Granger & Yoo (1990) test is used.
	\item {suroot.test = 'ocsb'}		: the Osborn-Chui-Smith-Birchenhall (1988) test is used (with null hypothesis that a seasonal unit root exists).
	\item {suroot.test = 'correlogram'}	: this function is written based on M4 Competition Seasonality Test.
}
}
\seealso{
\code{forecast}, \code{stlplus}, \code{stR}, \code{\link[stats]{stl}}, \code{\link[stats]{decompose}}, \code{tbats}, \code{seasadj}.
}
\author{
Ali Sabri Taylan and Hanife Taylan Selamlar
}
