% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse2full.R
\name{sparse2full}
\alias{sparse2full}
\title{Generates a full matrix form from a sparse form matrix}
\usage{
sparse2full(K = NULL)
}
\arguments{
\item{K}{A square matrix in sparse form (default = \code{NULL}).}
}
\value{
A full square matrix where individual names are assigned to
\code{rownames} and \code{colnames}.
If attribute \code{INVERSE} is found this is also passed to the full matrix.
}
\description{
Modifies the input sparse form matrix into its full form.
The sparse form has three columns per line, corresponding to the set:
\code{Row, Col, Value}, and is defined by a lower triangle row-wise
of the full matrix and is sorted as columns within row.
Individual names should be assigned as attributes: \code{attr(K, "rowNames")}
and \code{attr(K, "colNames")}. If these are not provided they are considered
as 1 to \eqn{n}.
}
\details{
Based on a function from ASReml-R 3 library by Butler \emph{et al.} (2009).
}
\examples{
# Get G matrix.
Gsp <- G.matrix(M = geno.apple, method = "VanRaden", sparseform = TRUE)$G.sparse
head(Gsp)
head(attr(Gsp, "rowNames"))

# Transform into full matrix.
G <- sparse2full(K = Gsp)
G[1:5, 1:5]

}
\references{
Butler, D.G., Cullis, B.R., Gilmour, A.R., and Gogel, B.J. 2009.
ASReml-R reference manual. Version 3. The Department of Primary
Industries and Fisheries (DPI&F).
}
