% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full2sparse.R
\name{full2sparse}
\alias{full2sparse}
\title{Generates a sparse form matrix from a full form matrix}
\usage{
full2sparse(K = NULL, drop.zero = TRUE)
}
\arguments{
\item{K}{A square matrix in full form (\eqn{n \times n}) (default = \code{NULL}).}

\item{drop.zero}{If \code{TRUE} observations equal to zero are dropped
(default = \code{TRUE}).}
}
\value{
A matrix in sparse form with columns: \code{Row, Col, Value}
together with the attributes \code{rowNames} and \code{colNames}.
If attribute \code{INVERSE} is found this is also passed to the sparse matrix.
}
\description{
Modifies the input square matrix into its sparse form with three columns per line,
corresponding to the set: \code{Row, Col, Value}. This matrix defines the lower triangle
row-wise of the original matrix and it is sorted as columns within row.
Values of zero on the matrix are dropped by default. Individual
names should be assigned to \code{rownames} and \code{colnames}.
}
\details{
Based on the function published by Borgognone \emph{et al.} (2016).
}
\examples{
# Get G matrix.
G <- G.matrix(M = geno.apple, method = "VanRaden", sparseform = FALSE)$G
G[1:5, 1:5]

# Transform matrix into sparse.
G.sparse <- full2sparse(K = G)
head(G.sparse)
head(attr(G.sparse, "rowNames"))
head(attr(G.sparse, "colNames"))

}
\references{
Borgognone, M.G., Butler, D.G., Ogbonnaya, F.C and Dreccer, M.F. 2016.
Molecular marker information in the analysis of multi-environment trial helps
differentiate superior genotypes from promising parents. Crop Science 56:2612-2628.
}
