% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_threshold.R
\name{cluster_threshold}
\alias{cluster_threshold}
\title{cluster_threshold}
\usage{
cluster_threshold(map, max_dist = sqrt(3))
}
\arguments{
\item{map}{3D map of logical values. \code{TRUE} if the voxel it to be clustered (e.g. it is supra-threshold).}

\item{max_dist}{maximum distance allowed to in the same cluster. By default:
\code{max_dist=sqrt(3)} i.e. comprises all the voxels up to the corners souranding the target voxel. A value such as
\code{max_dist=sqrt(2)} excludes the corners.}
}
\value{
a 3D map (same size of \code{map}) with integer values identifying the cluster and 0 elsewhere.
}
\description{
Get spatially-connected clusters starting from a 3D map of logical values
}
\examples{
\dontrun{
Tmap = RNifti::readNifti(system.file("extdata", "zstat.nii.gz", package="ARIbrain"))
clstr=cluster_threshold(Tmap>3.2)
table(clstr)
}
}
