% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_builders.R
\name{build_recm_formula}
\alias{build_recm_formula}
\title{RECM formula specification builder}
\usage{
build_recm_formula(parsed_formula, order, case)
}
\arguments{
\item{parsed_formula}{A list containing the formula parts as returned from
\code{\link{parse_formula}}.}

\item{order}{A numeric vector with the underlying ARDL order as returned from
\code{\link[=parse_order]{parse_order(restriction = FALSE)}}.}

\item{case}{An integer from 1-5 or a character string specifying whether the
'intercept' or the 'trend' have to participate in the 
long-run/cointegrating relationship/equation (see 'Details').}
}
\value{
\code{build_recm_formula} returns a list containing the full formula
  and the independent and dependent parts of the formula separated. The full
  formula is ready to be used as input in the \code{dynlm} function providing
  also the 'ect' (error correction term) to the data.
}
\description{
It creates the RECM (Restricted Error Correction Model) specification
according to the given "formula" and the corresponding "order" of the
underlying ARDL.
}
\seealso{
\code{\link{build_ardl_formula}}, \code{\link{build_uecm_formula}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
