% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multipliers.R
\name{multipliers}
\alias{multipliers}
\alias{multipliers.ardl}
\alias{multipliers.uecm}
\title{Multipliers estimation}
\usage{
multipliers(object, type = "lr", vcov_matrix = NULL)

\method{multipliers}{ardl}(object, type = "lr", vcov_matrix = NULL)

\method{multipliers}{uecm}(object, type = "lr", vcov_matrix = NULL)
}
\arguments{
\item{object}{An object of \code{\link[base]{class}} 'ardl' or 'uecm'.}

\item{type}{A character string describing the type of multipliers. The
default is "lr" for long-run (total) multipliers (see 'Details').}

\item{vcov_matrix}{The estimated covariance matrix of the random variable
that the transformation function uses to estimate the standard errors (and
so the t-statistics and p-values) of the multipliers. The default is
\code{vcov(object)} (when \code{vcov_matrix = NULL}), but other estimations
of the covariance matrix of the regression's estimated coefficients can
also be used (e.g., using \code{\link[sandwich]{vcovHC}} or
\code{\link[sandwich]{vcovHAC}}).}
}
\value{
\code{multipliers} returns a data.frame containing the independent
  variables (including possibly existing intercept or trend and excluding the
  fixed variables) and their corresponding standard errors, t-statistics and
  p-values.
}
\description{
\code{multipliers} is a generic function used to estimate short-run (impact),
interim and long-run (total) multipliers, along with their corresponding
standard errors, t-statistics and p-values.
}
\details{
The function invokes two different \code{\link[utils]{methods}}, one for
objects of \code{\link[base]{class}} 'ardl' and one for objects of
\code{class} 'uecm'. This is because of the different (but equivalent)
transformation functions that are used for each class/model ('ardl' and
'uecm') to estimate the multipliers.

Currently only the long-run (total) multipliers are supported (\code{type =
"lr"}). Other choices, including short-run (impact) and interim multipliers
are going to be available in future versions.

The delta method is used for approximating the standard errors (and thus the
t-statistics and p-values) of the estimated multipliers.
}
\section{Mathematical Formula}{
 \strong{Long-Run Multipliers:}
\describe{
  \item{As derived from an ARDL:}{}
}
\deqn{\mu = \frac{c_{0}}{1-\sum_{i=1}^{p}}}
\deqn{\delta = \frac{c_{1}}{1-\sum_{i=1}^{p}}}
\deqn{\theta_{j} = \frac{\sum_{l=0}^{q_{j}}b_{j,l}}{1-\sum_{i=1}^{p}} \;\;\;\;\; \forall j=1,\dots,k}

\describe{
  \item{As derived from an Unrestricted ECM:}{}
}
\deqn{\mu = \frac{c_{0}}{-\pi_{y}}}
\deqn{\delta = \frac{c_{1}}{-\pi_{y}}}
\deqn{\theta_{j} = \frac{\pi_{j}}{-\pi_{y}} \;\;\;\;\; \forall j=1,\dots,k}
}

\examples{
data(denmark)

## Estimate the long-run multipliers of an ARDL(3,1,3,2) model ---------

# From an ARDL model
ardl_3132 <- ardl(LRM ~ LRY + IBO + IDE, data = denmark, order = c(3,1,3,2))
mult_ardl <- multipliers(ardl_3132)
mult_ardl

# From an UECM
uecm_3132 <- uecm(ardl_3132)
mult_uecm <- multipliers(uecm_3132)
mult_uecm

all.equal(mult_ardl, mult_uecm)
}
\seealso{
\code{\link{ardl}}, \code{\link{uecm}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{math}
