% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitCellNum.R
\name{splitCellNum}
\alias{splitCellNum}
\title{Split CellNum sequence into a vector}
\usage{
splitCellNum(x)
}
\arguments{
\item{x}{a character or character vector containing a sequence of cell numbers or
an R object with a field named 'cellNum'}
}
\value{
integer vector or list of integer vectors with the sequence
CellNums splitted
}
\description{
\code{createQuadtree} returns a vector decomposing the given CellNum into the
sequence of the different cell numbers for each level.
}
\details{
CellNum is an integer with the concatenated sequence of hierarchical cell positions
inside a main cell. \code{splitCellNum} splits that sequence into a vector.
For instance, the CellNum of the top right cell would be 416 (fourth
in first partition, sixteenth in second partition)\cr
\if{html}{\figure{CellNum.jpg}{options: width=200 alt="Hyerarchical CellNums"}}
\if{latex}{\figure{CellNum.jpg}{options: width=4cm}}
}
\examples{
data("CharlestonPop")
CharlestonPop.IDs<-spatialPointsCellCodes(CharlestonPop, layers=2)
splitCellNum(CharlestonPop.IDs)

}
\seealso{
\itemize{
  \item{
   INSPIRE Data Specification on Geographical Grid Systems – Technical Guidelines
   \url{https://knowledge-base.inspire.ec.europa.eu/publications/inspire-data-specification-geographical-grid-systems-technical-guidelines_en}
  }
  \item{
   EEA reference grid dataset
   \url{https://data.europa.eu/euodp/data/dataset/data_eea-reference-grids-2}
  }
}
}
