% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clone_sizes.R
\name{count_clone_sizes}
\alias{count_clone_sizes}
\title{count the number of clonotype sizes per cell cluster in a seurat object integrated with a TCR library (will be deprecated soon)}
\usage{
count_clone_sizes(integrated_seurat_obj)
}
\arguments{
\item{integrated_seurat_obj}{Seurat object that has been integrated with a T-cell receptor library with \code{\link{integrate_tcr}}. More specifically, in the metadata, there must at least be the elements `seurat_clusters` and `raw_clonotype_id`}
}
\value{
Returns a list of `table` objects, where each element is tabled clonotype frequencies for the seurat cluster corresponding to the same index - 1. For example, the 5th element is a tabled frequency of counts that corresponds to the 4th seurat cluster (as seurat clusters are 0-indexed). If an element is `NULL`, it indicates that there were no corresponding T-cell receptor barcode for the cells in the cluster.
}
\description{
count the number of clonotype sizes per cell cluster in a seurat object integrated with a TCR library (will be deprecated soon)
}
\examples{
library(Seurat)
library(APackOfTheClones)
data("mini_clonotype_data","mini_seurat_obj")

# produce an integrated seurat_object
integrated_seurat_object <- integrate_tcr(mini_seurat_obj, mini_clonotype_data)
clonotype_counts <- count_clone_sizes(integrated_seurat_object)
clonotype_counts

}
\seealso{
\code{\link{integrate_tcr}}
}
