% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.net.nl.str.R
\name{perm.net.nl.str}
\alias{perm.net.nl.str}
\title{Nodes labels permutation keeping network structure}
\usage{
perm.net.nl.str(df, labels, rf = NULL, nperm, progress = TRUE)
}
\arguments{
\item{df}{a data frame whith nodes informations}

\item{labels}{a numeric or string vector indicating the columns (labels) to permute.}

\item{rf}{an integer (column id) or a string (column name) indicating the column holding the factor grouping multiple networks.}

\item{nperm}{an integer indicating the number of permutations wanted.}

\item{progress}{a boolean indicating the visualization of the permutation process.}
}
\value{
a list of data frames of length nperm + 1 with the first element of the list beeing the original data frame and the other elements, the permuted ones.
}
\description{
Permute node metrics while keeping their dependency
}
\details{
Permute network links weigths while keep same network structure (density, modularity, binary global clustering coefficient).
}
\examples{
df = met.strength(sim.m, df = sim.df, dfid = 1)
df = met.eigen(sim.m, df = df, dfid = 1)
head(df)
perm.net.nl.str(df, labels = c('strength', 'eigen'), nperm = 2)
}
\author{
Sebastian Sosa
}
