% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.dataStream.group.R
\name{perm.dataStream.group}
\alias{perm.dataStream.group}
\title{Data stream permutation for association data}
\usage{
perm.dataStream.group(
  df,
  scan,
  control_factor = NULL,
  perm,
  progress = TRUE,
  method = "sri"
)
}
\arguments{
\item{df}{A data frame.The data frame must have a column named 'ID'. ID have to be set as factors!}

\item{scan}{an integer indicating the column of scans of individuals association.}

\item{control_factor}{A confounding factor by which to control group associations.}

\item{perm}{number of permutations to perform.}

\item{progress}{a boolean indicating if the permutation process has to be visible.}

\item{method}{Which type of index to calculate:
\itemize{
\item 'sri' for Simple ratio index: \eqn{x \div x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'tw' for Twice-weigh index:\eqn{x/x+2yAB+yA+yB}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}
}
\value{
list of square association index matrices. The first element of the list is the non-permuted association index matrix.
}
\description{
Pre-network permutation on association data
}
\details{
Data stream permutation is a pre-network permutation approach. It is used on association data based on the gambit of the group.
}
\references{
Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.

Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
\keyword{internal}
