% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.ge.R
\name{met.ge}
\alias{met.ge}
\title{Global efficiency}
\usage{
met.ge(
  M,
  df = NULL,
  weighted = TRUE,
  shortest.weight = FALSE,
  normalization = TRUE,
  directed = TRUE,
  out = TRUE
)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{weighted}{if \emph{false}, it binarizes the square adjacency matrix M. Geodesic distances and diameter are based only on the presence or absence of edges.}

\item{shortest.weight}{if \emph{false},  and weighted is TRUE, it considers the highest weights as the shortest path. The value returned is the average of inverse of the all shortest distances (1/dij). Thus a higher value means a higher efficiency. Note that in constrast to unweighted graphs where global efficiency assumes values from 0 to 1, in weighted graphs the values depend on the weights associated to the links. It is therefore very useful to compare the global efficiency of a given weighted network with the global efficiency of a randomized version of the network or to a network of same size but different distribution of weights among the links. By itself this value is meaningless.}

\item{normalization}{normalizes the weights of the links i.e. divides them by the average strength of the network.}

\item{directed}{if \emph{false}, it symmetrizes the matrix. Otherwise, it calculates geodesic distances and diameter according to the directionality of the links.}

\item{out}{if \emph{true}, it considers outgoing ties.}
}
\value{
\itemize{
\item a double representing the global efficiency of the network if argument \emph{M} is a square matrix.
\item A list of doubles if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}. Each double represents the global efficiency of the corresponding matrix of the list.
\item A list of arguments \emph{df} with a new column of network global efficiency if argument\emph{df} is not \emph{NULL} and if argument \emph{M} is a list of matrices. The name of the column is adapted according to arguments values \emph{.weighted}, \emph{shortest.weight}, \emph{normalization}, \emph{directed} and \emph{out}.
\item A list of arguments \emph{df} with a new column of network global efficiency if argument \emph{df} is not \emph{NULL}, if argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and if argument \emph{df} is a list of data frames of same length as argument \emph{M}.
}
}
\description{
Calculates the global efficiency of a network.
}
\details{
The global efficiency provides a measure of how efficiently information is exchanged in a network. It can be calculated in binary or weighted networks, and for undirected or directed networks. Depending on the problematic, care is needed for the choice of calculation method (binary or weighted, directed or undirected, and using the lowest or the highest met.strength as shortest path).
}
\examples{
met.ge(sim.m)
}
\references{
Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez
}
