% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.assortatvityContinuous.r
\name{met.assortatvityContinuous}
\alias{met.assortatvityContinuous}
\title{Continuous assortativity}
\usage{
met.assortatvityContinuous(
  Matrix,
  se = FALSE,
  values,
  weighted = TRUE,
  df = NULL
)
}
\arguments{
\item{Matrix}{a square adjacency matrix.}

\item{se}{if \emph{true}, it calculates the standard error.}

\item{values}{The dataframe column that contains the vertices' attributes.}

\item{weighted}{if \emph{true}, it calculates the weigthed version.}
}
\value{
An integer representing the continuous assortativity index of the network.
}
\description{
Calculates the binary or weighted version of vertices Newman's assortativity for continuous attributes.
}
\details{
Assortativity (like the E-I index or the Moran 'I' statistic) allows the study of homophily (preferential interaction between nodes with similar attributes) and heterophily (the preferential interaction between nodes with different attributes). Attributes can be individual characteristics such as sex or age, or individual node metrics such as the met.degree, in which case it is referred to as assortativity by vertex met.degree.
}
\references{
Newman, M. E. (2003). Mixing patterns in networks. Physical Review E, 67(2), 026126.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Ivan Puga-Gonzalez, Sebastian Sosa
}
\keyword{internal}
