% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.eigen.single.R
\name{met.eigen.single}
\alias{met.eigen.single}
\title{Eigenvector Centrality}
\usage{
met.eigen.single(
  M,
  df = NULL,
  dfid = NULL,
  sym = TRUE,
  binary = FALSE,
  out = FALSE
)
}
\arguments{
\item{M}{a square adjacency matrix.}

\item{df}{a data frame of same length of the input matrix.}

\item{dfid}{an integer indicating the column of individual ids in argument \emph{df}}
}
\value{
Integer vector of each met.evcent centrality.
}
\description{
Calculate for all the vertices the node metric call met.evcent centrality.
}
\details{
met.evcent centrality is the first non-negative met.evcent value obtained through the linear transformation of an adjacency matrix. This centrality measure quantifies not only a node connectedness, but also the connections of the nodes to whom it is connected. Thus, a node can have a high met.evcent value by having a high met.degree or met.strength, or by being connected to nodes that have high degrees or strengths.
}
\references{
Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez
}
\keyword{internal}
