% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bowker.R
\name{bowker}
\alias{bowker}
\title{Perform Bowker's extension of McNemar's test}
\usage{
bowker(x, y = NULL, do.asymp = TRUE)
}
\arguments{
\item{x}{Factor of same length as y, or two-dimensional square table}

\item{y}{Factor of same length as x (or NULL if x is table) (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{bowker()} performs the Bowker's extension of McNemar's test and is used in chapter 12 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 12.12 from "Applied Nonparametric Statistical Methods" (5th edition)
bowker(ch12$side.effect.new, ch12$side.effect.old)

# Exercise 12.12 from "Applied Nonparametric Statistical Methods" (5th edition)
bowker(ch12$first.response, ch12$second.response)

}
