% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_initial_param}
\alias{get_initial_param}
\title{Construct initial values for the parameters to be optimized over}
\usage{
get_initial_param(model_name, sigma_0_2_ini = NA, num_param = NA)
}
\arguments{
\item{model_name}{fitted model, options from  ('BM','OU','FBM','OU+FBM',
'user_defined'), with Brownian motion as the default model. See 'Details'.}

\item{sigma_0_2_ini}{initial value for background noise, default is \code{NA}}

\item{num_param}{number of parameters need to be estimated in the model,
need to be non-NA value for \code{'user_defined'} model.}
}
\value{
A matrix with one row of initial values for the parameters to be
optimized over in \code{AIUQ} method of \code{SAM} class.
}
\description{
Construct initial values for the parameters to be optimized over in \code{AIUQ}
method of \code{SAM} class.
}
\details{
If \code{model_name} equals 'user_defined', then \code{num_param} need to be
provided to determine the length of the initial values vector.
}
\examples{
library(AIUQ)
get_initial_param(model_name = "BM")
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
