% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fbm_particle_intensity}
\alias{fbm_particle_intensity}
\title{Simulate 2D particle trajectory follows fBM}
\usage{
fbm_particle_intensity(pos0, M, len_t, sigma, H)
}
\arguments{
\item{pos0}{initial position for \code{M} particles, matrix with dimension M by 2}

\item{M}{number of particles}

\item{len_t}{number of time steps}

\item{sigma}{distance moved per time step}

\item{H}{Hurst parameter, value between 0 and 1}
}
\value{
Position matrix with dimension \code{M}\eqn{\times}{\%\times}\code{len_t}
by 2 for particle trajectory. The first \code{M} rows being the initial position
\code{pos0}.
}
\description{
Simulate 2D particle trajectory follows fraction Brownian Motion(fBM) for
\code{M} particles.
}
\examples{
library(AIUQ)
M = 10
len_t = 50
sigma = 2
H = 0.3
pos0 = matrix(100/8+0.75*100*runif(M*2),nrow=M,ncol=2)

pos = fbm_particle_intensity(pos0=pos0,M=M,len_t=len_t,sigma=sigma,H=H)
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
