% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiles.R
\name{wkmCompareQuantiles}
\alias{wkmCompareQuantiles}
\title{wkmCompareQuantiles}
\usage{
wkmCompareQuantiles(tau, formula, data, conf.level = 0.95, null.value = 1,
  method = "ratio", p.value = FALSE)
}
\arguments{
\item{tau}{number between 0 and 1 specifying the quantile}

\item{formula}{an object of class '"formula"' specifying the conditional survival model}

\item{data}{data frame containing the variables in formula}

\item{conf.level}{confidence level (or NULL if no confidence interval should be calculated)}

\item{null.value}{true value of quantile ratio or difference}

\item{method}{either '"ratio"' or '"difference"'}

\item{p.value}{if TRUE p.value will be calculated (requires null.value)}
}
\value{
An object of class '"survQuantile"', i.e. a list containing the estimated quantiles, confidence interval and p.value (if p.value = TRUE)
}
\description{
Compare quantiles of two independent samples (ratio or difference) based on (weighted-) Kaplan-Meier estimator
}
\examples{
T <- c(rexp(100, 1), rexp(100, 2))
C <- c(rexp(100, 1), rexp(100, 2))
Y <- pmin(T, C)
D <- T <= C
Z <- rep(c(0,1), c(100, 100)) # treatment indicator
wkmCompareQuantiles(0.5, Surv(Y, D) ~ Z, data.frame(Y=Y, D=D, Z=Z))
}
\references{
su_nonparametric_1993
}

