% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/impute_primary.R
\name{latch_accel}
\alias{latch_accel}
\alias{get_latch_index}
\alias{get_latch_values}
\alias{get_latch_entries}
\alias{latch_replicate}
\alias{impute_C}
\alias{impute_primary}
\alias{idle_sleep_impute}
\title{Impute primary accelerometer data for missing packets}
\usage{
latch_accel(vector_size, accel_input, samp_rate)

get_latch_index(missing_times, reference_times)

get_latch_values(indices, RAW)

get_latch_entries(samp_rate, timestamps, accel_x, accel_y, accel_z,
  return_empty = FALSE)

latch_replicate(start_time, stop_time, x_val, y_val, z_val)

impute_C(gaps, object)

impute_primary(object, verbose)

idle_sleep_impute(object, events, info, tz, verbose)
}
\arguments{
\item{vector_size}{int. The size of the final vector}

\item{accel_input}{NumericVector. The accelerometer values to reference for
latching}

\item{samp_rate}{int. The sampling rate}

\item{missing_times}{vector of missing timestamps for which to identify a
latch index}

\item{reference_times}{vector of reference timestamps for use in determining
the latch index}

\item{indices}{IntegerVector containing latch indices}

\item{RAW}{DataFrame containing raw acceleration data}

\item{timestamps}{vector of timestamps on which to perform latching}

\item{accel_x}{vector of x-axis accelerations on which to perform latching}

\item{accel_y}{vector of y-axis accelerations on which to perform latching}

\item{accel_z}{vector of z-axis accelerations on which to perform latching}

\item{return_empty}{bool. Return an empty data frame?}

\item{gaps}{DataFrame with gap information}

\item{object}{data frame of primary accelerometer data}

\item{verbose}{logical. Print updates to console?}

\item{events}{the result of parsing EVENTS packets}

\item{info}{the result of \code{\link{parse_info_txt}}}

\item{tz}{character. The timezone to use}
}
\description{
Impute primary accelerometer data for missing packets
}
\keyword{internal}
