% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AFMFractalDimensionAnalyser.R
\name{getFractalDimensions}
\alias{getFractalDimensions}
\title{Calculate 2D fractal dimensions and scales of an AFM Image}
\usage{
getFractalDimensions(AFMImage)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\value{
a data.table with the calculated fractal dimensions and scales
}
\description{
\code{getFractalDimensions} calculates fractal dimensions and scales of an \code{\link{AFMImage}} with \code{\link[fractaldim]{fd.estim.method}} from the \code{\link{fractaldim}} package.
}
\examples{
library(AFM)

data(AFMImageOfAluminiumInterface)
print(getFractalDimensions(AFMImageOfAluminiumInterface))
}
\author{
M.Beauvais
}
\references{
Gneiting2012, Tilmann Gneiting, Hana Sevcikova and Donald B. Percival 'Estimators of Fractal Dimension: Assessing the Roughness of Time Series and Spatial Data - Statistics in statistical Science, 2012, Vol. 27, No. 2, 247-277'
}
\seealso{
\code{\link{fractaldim}}
}

