% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{estCellPercent.svmdecon}
\alias{estCellPercent.svmdecon}
\title{SVMDECON deconvolution}
\usage{
estCellPercent.svmdecon(
  refExpr,
  geneExpr,
  marker_set = NULL,
  useOldVersion = F,
  progressBar = T
)
}
\arguments{
\item{refExpr}{a data frame representing immune cell expression profiles. Each row represents an expression of a gene, and each column represents a different immune cell type. colnames contains the name of each immune cell type and the rownames includes the genes' symbol. The names of each immune cell type and the symbol of each gene should be unique. Any gene with missing expression values must be excluded.}

\item{geneExpr}{a data frame representing RNA-seq or microarray gene-expression profiles of a given complex tissue. Each row represents an expression of a gene, and each column represents a different experimental sample. colnames contain the name of each sample and rownames includes the genes' symbol. The name of each individual sample and the symbol of each gene should be unique. Any gene with missing expression values should be excluded.}

\item{marker_set}{data frames of one column, that includes a preselected list of genes that likely discriminate well between the immune-cell types given in the reference data. (DEFAULT: NULL, i.e. one for each gene in the refExpr)}

\item{useOldVersion}{Set the TRUE to 2^ the data (DEFAULT: FALSE)}

\item{progressBar}{Set to TRUE to show a progress bar  (DEFAULT: TRUE)}
}
\value{
A matrix with cell type estimates for each samples
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

cellEst <- estCellPercent.svmdecon(refExpr=smallLM22, geneExpr=fullLM22)
}
\description{
Use SVMDECON to estimate the cell count percentage
Performs considerably worse in deconvolution than DCQ

cellEst <- estCellPercent.svmdecon(refExpr,  geneExpr)
}
