% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztplnMLE.r
\name{ztplnMLE}
\alias{ztplnMLE}
\title{MLE for the Zero-truncated Poisson Lognormal distribution}
\usage{
ztplnMLE(
  n,
  lower_mu = 0,
  upper_mu = log(max(n)),
  lower_sig = 0.001,
  upper_sig = 10,
  type1 = TRUE
)
}
\arguments{
\item{n}{a integer vector of counts}

\item{lower_mu, upper_mu}{numeric values of lower and upper bounds for mean of
the variables's natrual logarithm.}

\item{lower_sig, upper_sig}{numeric values of lower and upper bounds for
standard deviatoin of the variables's natrual logarithm}

\item{type1}{logical; if TRUE, Use type 1 ztpln else use type 2.}
}
\value{
\item{convergence}{An integer code. 0 indicates successful
convergence.}

\item{iterations}{Number of iterations performed.}

\item{message}{A character string giving any additional information
returned by the optimizer, or NULL. For details, see PORT documentation.}

\item{evaluation}{Number of objective function and gradient function
evaluations}

\item{mu}{Maximum likelihood estimates of mu}

\item{sig}{Maximum likelihood estimates of sig}

\item{loglik}{loglikelihood}
}
\description{
\code{ztplnMLE} fits the Zero-truncated Poisson lognormal distribution to data and
estimates parameters mean \code{mu} and standard deviation \code{sig} in the lognormal
distribution
}
\details{
The function searches the maximum likelihood estimates of mean \code{mu} and
standard deviation \code{sig} using the optimization procedures in
\code{\link{nlminb}}.
}
\examples{
y <- rztpln(100, 3, 2)
ztplnMLE(y)
}
