% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{z22_grid}
\alias{z22_grid}
\title{Get INSPIRE grid}
\usage{
z22_grid(res, year = 2019, as = c("df", "sf", "raster"), update_cache = FALSE)
}
\arguments{
\item{res}{Resolution of the grid. Can be \code{"100m"}, \code{"250m"},
\code{"1km"}, \code{"5km"}, \code{"10km"}, or \code{"100km"}.}

\item{year}{Version of the grid. Can be 2015, 2017, 2018 and 2019. Defaults
to the latest version.}

\item{as}{Specifies the output class. Must be one of \code{"df"},
\code{"sf"}, or \code{"raster"}. If \code{"df"} (default), returns flat
coordinates in a dataframe. If \code{"sf"} (and the \code{sf} package is
installed), converts the coordinates to an \code{sf} tibble. If
\code{"raster"} (and the \code{terra} package is installed), converts the
coordinates to a \code{\link[terra:rast]{SpatRaster}}.}

\item{update_cache}{By default, both functions cache attribute files for
the remainder of the R session. They are downloaded to a temporary directory
and - if the file to download already exists - are recovered from the cache.
In other words, when rerunning the same request multiple times, the
subsequent calls should be much faster. If \code{TRUE}, disables caching
for this call and overwrites the currently cached attribute file (if any)
with a fresh one. Defaults to \code{FALSE}, i.e. always cache.}
}
\value{
A tibble, \code{\link[terra:rast]{SpatRaster}} or
\code{\link[sf:st_as_sf]{sf}} tibble depending on the \code{as} argument.
}
\description{
Retrieve the entire INSPIRE grid.

Unlike the feature grids retrieved from \code{\link{z22_data}},
the INSPIRE grid encompasses the entire area of Germany. You can thus use
it to join with the incomplete feature grids from \code{z22_data}
to create a complete dataset.
}
\details{
Note the uncompressed object sizes of the output (2019 version):

\itemize{
 \item{100 m: 38 million cells, 291 MB}
 \item{250 m: 6 million cells, 47 MB}
 \item{1 km: 384 thousand cells, 3 MB}
 \item{5 km: 16 thousand cells, 0.12 MB}
 \item{10 km: 4 thousand cells, 0.03 MB}
}
}
\examples{
\donttest{# Get high-res grid as tibble
z22_grid("100m")

# Get low-res grid as raster
z22_grid("1km", as = "raster")}
}
