% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchData.R
\name{searchData}
\alias{searchData}
\title{Extract dataset information based on a list of character strings}
\usage{
searchData(searchList = list(list("varname", "chl")))
}
\arguments{
\item{searchList}{- A list of lists
each list will contain the field to search and the search string}
}
\value{
dataframe with any matching information
}
\description{
\code{searchData} finds the all datasets that contain the supplied string
in the given dataset field
}
\section{Details}{

searchData will search for the given string in any of the fields
dtypename,datasetname,longname,varname.  Over the list of
searchs provided, the search sequentially refines
the search result based on the next list in the list of lists.

It will return the following
information about any dataset that matches the string:
\itemize{
\item dtypename
\item datasetname
\item longname
\item varname
\item hasAlt
\item latSouth
\item lon360
\item minLongitude
\item maxLongitude
\item longitudeSpacing
\item minLatitude
\item maxLatitude
\item latitudeSpacing
\item minAltitude
\item maxAltitude
\item minTime
\item maxTime
\item timeSpacing
\item infoUrl
 }
}

\examples{
list1 <- 'varname:chl'
list2 <- 'datasetname:mday'
mylist <- c(list1, list2)
searchResult <- searchData(mylist)
}
