% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_prop}
\alias{set_prop}
\title{Set a summary property}
\usage{
set_prop(xpdb, ..., .problem = NULL, .subprob = NULL)
}
\arguments{
\item{xpdb}{<\code{xpose_data}\link[xpose:xpose_data]{xpose::xpose_data}> object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> defining which properties to transform.
Argument should be valid label.}

\item{.problem}{<\code{numeric}> Problem number to use. Uses all problem if not provided.}

\item{.subprob}{<\code{numeric}> Subproblem number to use. Uses the xpose default if not provided.}
}
\value{
\code{xp_xtras} object
}
\description{
Set a summary property
}
\details{
Although one might be tempted to set custom properties using this function,
with the intention to maintain cross-functionality with \code{xpose}, users cannot
set a non-existent property with this function. When used internally, workarounds
to this semi-limitation are used.
}
\examples{

set_prop(xpose::xpdb_ex_pk, descr = "New model description") \%>\%
  xpose::get_summary()

}
