% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose_set.R
\name{mutate.xpose_set}
\alias{mutate.xpose_set}
\title{Mutation method for xpose_set}
\usage{
\method{mutate}{xpose_set}(.data, ..., .force = FALSE, .retest = !.force, .rowwise = FALSE)
}
\arguments{
\item{.data}{<\code{\link{xpose_set}}> An xpose_set object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Mutations to apply to the xpose_set (passed through to <\code{\link[dplyr:mutate]{dplyr::mutate}}>)}

\item{.force}{<\code{\link{logical}}> Should top-level elements be allowed to be manipulated? (default: \code{FALSE})}

\item{.retest}{<\code{\link{logical}}> Should the xpose_set be retested after mutation? (default: \code{!force})}

\item{.rowwise}{<\code{\link{logical}}> Should the mutation be applied rowwise? (default: \code{FALSE})}
}
\value{
A set with updated top-level data (unless focused)
}
\description{
Mutation method for xpose_set
}
\examples{
xpdb_set \%>\%
  # Adds foo = bar for all objects in the set
  mutate(foo = "bar") \%>\%
  # Reshape to visualize
  reshape_set()

}
