% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose_set.R
\name{expose_property}
\alias{expose_property}
\title{Expose a property of xpdb objects in an xpose_set}
\usage{
expose_property(xpdb_s, ..., .problem = NULL, .subprob = NULL, .method = NULL)
}
\arguments{
\item{xpdb_s}{<\code{\link{xpose_set}}> An xpose_set object}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> One or more properties to expose}

\item{.problem}{<\code{numeric}> Problem number to apply this relationship.}

\item{.subprob}{<\code{numeric}> Problem number to apply this relationship.}

\item{.method}{<\code{numeric}> Problem number to apply this relationship.}
}
\value{
An \code{xpose_set} object with the properties exposed
}
\description{
Expose a property of xpdb objects in an xpose_set
}
\details{
The property returned will be top-level, and to avoid conflicting
names will be prepended by \code{..} (e.g., \code{..descr}).

For some properties, transformations are applied automatically to
make them more useful. This includes:
\itemize{
\item \code{etashk} and \code{epsshk}: transformed to numeric vectors as in <\code{\link{get_shk}}>
\item \code{ofv} and other per-problem properties: transformed as
needed and pulls from each \code{xpdb} default problem.
}
}
\examples{

xpdb_set <- expose_property(xpdb_set, descr)
xpdb_set$mod1$..descr

xpdb_set <- expose_property(xpdb_set, etashk)
xpdb_set$mod1$..etashk

}
\seealso{
\code{\link[=expose_param]{expose_param()}}
}
