% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConditionalKNNSampler.R
\name{ConditionalKNNSampler}
\alias{ConditionalKNNSampler}
\title{k-Nearest Neighbors Conditional Sampler}
\description{
Implements conditional sampling using k-nearest neighbors (kNN).
For each observation, finds the \code{k} most similar observations based on conditioning
features, then samples the target features from these neighbors.
}
\details{
This sampler approximates the conditional distribution \eqn{P(X_B | X_A = x_A)} by:
\enumerate{
\item Finding the k nearest neighbors of \eqn{x_A} in the training data
\item Sampling uniformly from the target feature values \eqn{X_B} of these k neighbors
}

This is a simple, non-parametric approach that:
\itemize{
\item Requires no distributional assumptions
\item Handles mixed feature types (numeric, integer, factor, ordered, logical)
\item Is computationally efficient (no model fitting required)
\item Adapts locally to the data structure
}

The method is related to hot-deck imputation and kNN imputation techniques used in
missing data problems. As \eqn{k \to \infty} and \eqn{k/n \to 0}, the kNN conditional
distribution converges to the true conditional distribution under mild regularity
conditions (Lipschitz continuity).

\strong{Distance Metrics:}

The sampler supports two distance metrics:
\itemize{
\item \strong{Euclidean}: For numeric/integer features only. Standardizes features before computing distances.
\item \strong{Gower}: For mixed feature types. Handles numeric, factor, ordered, and logical features.
Numeric features are range-normalized, categorical features use exact matching (0/1).
}

The \code{distance} parameter controls which metric to use:
\itemize{
\item \code{"auto"} (default): Automatically selects Euclidean for all-numeric features, Gower otherwise
\item \code{"euclidean"}: Forces Euclidean distance (errors if non-numeric features present)
\item \code{"gower"}: Forces Gower distance (works with any feature types)
}

\strong{Advantages:}
\itemize{
\item Very fast (no model training)
\item Works with any feature types
\item Automatic distance metric selection
\item Naturally respects local data structure
}

\strong{Limitations:}
\itemize{
\item Sensitive to choice of \code{k}
\item The full task data is required for prediction
\item Can produce duplicates if \code{k} is small
\item May not extrapolate well to new regions
}
}
\examples{
library(mlr3)
task = tgen("friedman1")$generate(n = 100)
sampler = ConditionalKNNSampler$new(task, k = 5)

# Sample features conditioned on others
test_data = task$data(rows = 1:5)
sampled = sampler$sample_newdata(
  feature = c("important2", "important3"),
  newdata = test_data,
  conditioning_set = "important1"
)

}
\references{
Little R, Rubin D (2019).
\emph{Statistical Analysis with Missing Data}, 3rd edition.
John Wiley & Sons, Hoboken, NJ.
ISBN 9780470526798.

Troyanskaya O, Cantor M, Sherlock G, Brown P, Hastie T, Tibshirani R, Botstein D, Altman R (2001).
\dQuote{Missing Value Estimation Methods for DNA Microarrays.}
\emph{Bioinformatics}, \bold{17}(6), 520--525.
\doi{10.1093/bioinformatics/17.6.520}.
}
\section{Super classes}{
\code{\link[xplainfi:FeatureSampler]{xplainfi::FeatureSampler}} -> \code{\link[xplainfi:ConditionalSampler]{xplainfi::ConditionalSampler}} -> \code{ConditionalKNNSampler}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{feature_types}}{(\code{character()}) Feature types supported by the sampler.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConditionalKNNSampler-new}{\code{ConditionalKNNSampler$new()}}
\item \href{#method-ConditionalKNNSampler-sample}{\code{ConditionalKNNSampler$sample()}}
\item \href{#method-ConditionalKNNSampler-sample_newdata}{\code{ConditionalKNNSampler$sample_newdata()}}
\item \href{#method-ConditionalKNNSampler-clone}{\code{ConditionalKNNSampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="print"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-print'><code>xplainfi::FeatureSampler$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConditionalKNNSampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-ConditionalKNNSampler-new}{}}}
\subsection{Method \code{new()}}{
Creates a new ConditionalKNNSampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConditionalKNNSampler$new(task, conditioning_set = NULL, k = 5L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task}) Task to sample from.}

\item{\code{conditioning_set}}{(\code{character} | \code{NULL}) Default conditioning set to use in \verb{$sample()}.}

\item{\code{k}}{(\code{integer(1)}: \code{5L}) Number of nearest neighbors to sample from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConditionalKNNSampler-sample"></a>}}
\if{latex}{\out{\hypertarget{method-ConditionalKNNSampler-sample}{}}}
\subsection{Method \code{sample()}}{
Sample features from their kNN-based conditional distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConditionalKNNSampler$sample(
  feature,
  row_ids = NULL,
  conditioning_set = NULL,
  k = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{(\code{character()}) Feature name(s) to sample.}

\item{\code{row_ids}}{(\code{integer()} | \code{NULL}) Row IDs from task to use as conditioning values.}

\item{\code{conditioning_set}}{(\code{character()} | \code{NULL}) Features to condition on.
If \code{NULL}, samples from marginal distribution (random sampling from training data).}

\item{\code{k}}{(\code{integer(1)} | \code{NULL}) Number of neighbors. If \code{NULL}, uses stored parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified copy with sampled feature(s).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConditionalKNNSampler-sample_newdata"></a>}}
\if{latex}{\out{\hypertarget{method-ConditionalKNNSampler-sample_newdata}{}}}
\subsection{Method \code{sample_newdata()}}{
Sample from external data conditionally.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConditionalKNNSampler$sample_newdata(
  feature,
  newdata,
  conditioning_set = NULL,
  k = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{(\code{character()}) Feature(s) to sample.}

\item{\code{newdata}}{(\code{\link[data.table:data.table]{data.table}}) External data to use.}

\item{\code{conditioning_set}}{(\code{character()} | \code{NULL}) Features to condition on.}

\item{\code{k}}{(\code{integer(1)} | \code{NULL}) Number of neighbors. If \code{NULL}, uses stored parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified copy with sampled feature(s).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConditionalKNNSampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ConditionalKNNSampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConditionalKNNSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
