% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_metseason.R
\name{anlz_metseason}
\alias{anlz_metseason}
\title{Extract period (seasonal) metrics from fitted GAM}
\usage{
anlz_metseason(
  mod,
  metfun = mean,
  doystr = 1,
  doyend = 364,
  nsim = 10000,
  yromit = NULL,
  ...
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{metfun}{function input for metric to calculate, e.g., \code{mean}, \code{var}, \code{max}, etc}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}

\item{nsim}{numeric indicating number of random draws for simulating uncertainty}

\item{yromit}{optional numeric vector for years to omit from the output}

\item{...}{additional arguments passed to \code{metfun}, e.g., \code{na.rm = TRUE}}
}
\value{
A data frame of period metrics
}
\description{
Extract period (seasonal) metrics from fitted GAM
}
\details{
This function estimates a metric of interest for a given seasonal period each year using results from a fitted GAM (i.e., from \code{\link{anlz_gam}}).  The estimates are based on the predicted values for each seasonal period, with uncertainty of the metric based on repeated sampling of the predictions following uncertainty in the model coefficients.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
anlz_metseason(mod, mean, doystr = 90, doyend = 180, nsim = 100)
}
\concept{analyze}
