% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_to_fst.R
\name{import_to_fst}
\alias{import_to_fst}
\title{Read a Workplace Analytics query in '.csv' using and create a '.fst'
file in the same directory for faster reading}
\usage{
import_to_fst(path, ...)
}
\arguments{
\item{path}{String containing the path to the Workplace Analytics query to be
imported. The input file must be a CSV file, and the file extension must be
explicitly entered, e.g. \code{"/files/standard query.csv"}. The converted FST
file will be saved in the same directory with a different file extension.}

\item{...}{Additional arguments to pass to \code{import_wpa()}.}
}
\value{
There is no return value. A file with '.fst' extension is written to the same
directory where the '.csv' file is read in.
}
\description{
Uses \code{import_wpa()} to read a Workplace Analytics query in
'.csv' and convert this into the serialized '.csv' format which is much
faster to read. The 'fst' package must be installed, or an error message is
returned.
}
\details{
The \href{https://www.fstpackage.org/}{fst} package provides a way to serialize
data frames in R which makes loading data much faster than CSV.
\code{import_to_fst()} converts a CSV file into a FST file in the specified
directory.

Once this FST file is created, it can be read into R using
\code{fst::read_fst()}. Since \code{import_to_fst()} only does conversion but not
loading, it should normally only be run once at the beginning of each piece
of analysis, and \code{fst::read_fst()} should take over the job of data loading
at the start of your analysis script.

Internally, \code{import_to_fst()} uses \code{import_wpa()}, and additional arguments
to \code{import_wpa()} can be passed with \code{...}.
}
\seealso{
Other Import and Export: 
\code{\link{copy_df}()},
\code{\link{create_dt}()},
\code{\link{export}()},
\code{\link{import_wpa}()},
\code{\link{standardise_pq}()}
}
\concept{Import and Export}
