% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{chi_features_set}
\alias{chi_features_set}
\alias{chi_features_res}
\title{Chicago Features Example Data}
\description{
The package supplies two pre-generated workflow sets, \code{two_class_set}
and \code{chi_features_set}, and associated sets of model fits
\code{two_class_res} and \code{chi_features_res}.

The \verb{two_class_*} objects are based on a binary classification problem
using the \code{two_class_dat} data from the modeldata package. The six
models utilize either a bare formula or a basic recipe utilizing
\code{recipes::step_YeoJohnson()} as a preprocessor, and a decision tree,
logistic regression, or MARS model specification. See \code{?two_class_set}
for source code.

The \verb{chi_features_*} objects are based on a regression problem using the
\code{Chicago} data from the modeldata package. Each of the three models
utilize a linear regression model specification, with three different
recipes of varying complexity. The objects are meant to approximate the
sequence of models built in Section 1.3 of Kuhn and Johnson (2019). See
\code{?chi_features_set} for source code.
}
\details{
See below for the source code to generate the Chicago Features example
workflow sets:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(workflowsets)
library(workflows)
library(modeldata)
library(recipes)
library(parsnip)
library(dplyr)
library(rsample)
library(tune)
library(yardstick)
library(dials)

# ------------------------------------------------------------------------------
# Slightly smaller data size
data(Chicago)
Chicago <- Chicago[1:1195,]

time_val_split <-
   sliding_period(
      Chicago,
      date,
      "month",
      lookback = 38,
      assess_stop = 1
   )

# ------------------------------------------------------------------------------

base_recipe <-
   recipe(ridership ~ ., data = Chicago) \%>\%
   # create date features
   step_date(date) \%>\%
   step_holiday(date) \%>\%
   # remove date from the list of predictors
   update_role(date, new_role = "id") \%>\%
   # create dummy variables from factor columns
   step_dummy(all_nominal()) \%>\%
   # remove any columns with a single unique value
   step_zv(all_predictors()) \%>\%
   step_normalize(all_predictors())

date_only <-
   recipe(ridership ~ ., data = Chicago) \%>\%
   # create date features
   step_date(date) \%>\%
   update_role(date, new_role = "id") \%>\%
   # create dummy variables from factor columns
   step_dummy(all_nominal()) \%>\%
   # remove any columns with a single unique value
   step_zv(all_predictors())

date_and_holidays <-
   recipe(ridership ~ ., data = Chicago) \%>\%
   # create date features
   step_date(date) \%>\%
   step_holiday(date) \%>\%
   # remove date from the list of predictors
   update_role(date, new_role = "id") \%>\%
   # create dummy variables from factor columns
   step_dummy(all_nominal()) \%>\%
   # remove any columns with a single unique value
   step_zv(all_predictors())

date_and_holidays_and_pca <-
   recipe(ridership ~ ., data = Chicago) \%>\%
   # create date features
   step_date(date) \%>\%
   step_holiday(date) \%>\%
   # remove date from the list of predictors
   update_role(date, new_role = "id") \%>\%
   # create dummy variables from factor columns
   step_dummy(all_nominal()) \%>\%
   # remove any columns with a single unique value
   step_zv(all_predictors()) \%>\%
   step_pca(!!stations, num_comp = tune())

# ------------------------------------------------------------------------------

lm_spec <- linear_reg() \%>\% set_engine("lm")

# ------------------------------------------------------------------------------

pca_param <-
   parameters(num_comp()) \%>\%
   update(num_comp = num_comp(c(0, 20)))

# ------------------------------------------------------------------------------

chi_features_set <-
   workflow_set(
      preproc = list(date = date_only,
                     plus_holidays = date_and_holidays,
                     plus_pca = date_and_holidays_and_pca),
      models = list(lm = lm_spec),
      cross = TRUE
   )

# ------------------------------------------------------------------------------

chi_features_res <-
   chi_features_set \%>\%
   option_add(param_info = pca_param, id = "plus_pca_lm") \%>\%
   workflow_map(resamples = time_val_split, grid = 21, seed = 1, verbose = TRUE)
}\if{html}{\out{</div>}}
}
\examples{
data(chi_features_set)

chi_features_set
}
\references{
Max Kuhn and Kjell Johnson (2019) \emph{Feature Engineering and
Selection}, \url{https://bookdown.org/max/FES/a-more-complex-example.html}
}
\keyword{datasets}
