% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes.R
\name{reproduce}
\alias{reproduce}
\title{Reproduce WORCS Project}
\usage{
reproduce(worcs_directory = ".", verbose = TRUE, check_endpoints = TRUE, ...)
}
\arguments{
\item{worcs_directory}{Character, indicating the WORCS project directory
to which to save data. The default value "." points to the current directory.
Default: '.'}

\item{verbose}{Logical. Whether or not to print status messages to the
console. Default: \code{TRUE}}

\item{check_endpoints}{Logical. Whether or not to call \code{check_endpoints()}
after reproducing the recipe. Default: \code{TRUE}}

\item{...}{Additional arguments.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Evaluate the recipe contained in a WORCS project to derive its
endpoints.
}
\examples{
# Create directory to run the example
if(requireNamespace("withr", quietly = TRUE)){
withr::with_tempdir({
file.create(".worcs")
worcs:::add_recipe(recipe = 'writeLines("test", "test.txt")')
})
}
}
\seealso{
\code{\link[worcs]{add_endpoint}}
\code{\link[worcs]{snapshot_endpoints}}
\code{\link[worcs]{check_endpoints}}
}
