% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\encoding{UTF-8}
\name{delta_method}
\alias{delta_method}
\title{Delta Method for Parametric Lifetime Distributions}
\usage{
delta_method(p, loc_sc_params, loc_sc_varcov, distribution = c("weibull",
  "lognormal", "loglogistic", "normal", "logistic", "sev", "weibull3",
  "lognormal3", "loglogistic3"), direction = c("y", "x"))
}
\arguments{
\item{p}{a numeric value of a probability or a quantile. If the standard error
of quantile is of interest a specific probability needs to be supplied and if
the standard error of a standardized quantile (z-value) should be calculated
a specific quantile should be provided.}

\item{loc_sc_params}{a (named) numeric vector of estimated
(by Maximum Likelihood) location and scale parameters for a specified
distribution. The order of elements is important. First entry needs to be
the location parameter \eqn{\mu} and the second element needs to be the
scale parameter \eqn{\sigma}. If a three-parametric model is used the third element
is the threshold parameter \eqn{\gamma}.}

\item{loc_sc_varcov}{a (named) numeric matrix of estimated
(by Maximum Likelihood) location and scale variances and covariances for a
specified distribution. The order of elements is important. First entry
of the diagonal needs to be the variance of the location parameter
Var(\eqn{\mu}) and the second element of the diagonal needs to be the
variance of the scale parameter Var(\eqn{\sigma}). If a three-parametric model
is used the third element of the diagonal needs to be the variance of the
threshold parameter Var(\eqn{\gamma}).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"}, \code{"sev"} \emph{(smallest extreme value)},
\code{"weibull3"}, \code{"lognormal3"} or \code{"loglogistic3"}.
Other distributions have not been implemented yet.}

\item{direction}{a character string specifying the direction of the computed
standard errors. Must be either "y" (used for confidence intervals of failure
probabilities in \code{\link{confint_fisher}}) or "x" (used for confidence
intervals of quantiles in \code{\link{confint_fisher}}). If \code{p} is a
quantile then \emph{direction} needs to be "y" and vice versa.}
}
\value{
A numeric value with estimated standard errors of quantiles or standardized
  z values. Both are required for the computation of normal approximation
  confidence intervals. If standard errors of standardized z values are compueted
  one can calculate confidence intervals for distribution probabilities (z-procedure,
  which is used inside \code{\link{confint_fisher}}).
}
\description{
The Delta Method estimates the standard error for quantities that can be
written as non-linear functions of ML estimators like quantiles. I.e. the
(log-)location-scale (and threshold) parameters and variance-covariance matrix
of these need to be estimated by Maximum Likelihood.
}
\examples{
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

mle <- ml_estimation(x = obs, event = state,
                     distribution = "weibull", conf_level = 0.95)
delta_prob <- sapply(obs, delta_method,
                          loc_sc_params = mle$loc_sc_coefficients,
                          loc_sc_varcov = mle$loc_sc_vcov,
                          distribution = "weibull",
                          direction = "y")
}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
