% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcpc.R
\name{bcpc_query}
\alias{bcpc_query}
\title{Query https://pesticidecompendium.bcpc.org}
\usage{
bcpc_query(
  query,
  from = c("name", "cas"),
  verbose = getOption("verbose"),
  type,
  ...
)
}
\arguments{
\item{query}{character; search string}

\item{from}{character; type of input ('cas' or 'name')}

\item{verbose}{logical; print message during processing to console?}

\item{type}{deprecated}

\item{...}{additional arguments to internal utility functions}
}
\value{
A list of eight entries: common-name, status, preferred IUPAC Name,
IUPAC Name, cas, formula, activity, subactivity, inchikey, inchi and source
url.
}
\description{
Query the BCPC Compendium of Pesticide Common Names
\url{https://pesticidecompendium.bcpc.org}
formerly known as Alan Woods Compendium of Pesticide Common Names
}
\note{
for from = 'cas' only the first matched link is returned.
Please respect Copyright, Terms and Conditions
\url{https://pesticidecompendium.bcpc.org/legal.html}!
}
\examples{
\dontrun{
bcpc_query('Fluazinam', from = 'name')
out <- bcpc_query(c('Fluazinam', 'Diclofop'), from = 'name')
out
# extract subactivity from object
sapply(out, function(y) y$subactivity[1])

# use CAS-numbers
bcpc_query("79622-59-6", from = 'cas')
}
}
\references{
Eduard Szöcs, Tamás Stirling, Eric R. Scott, Andreas Scharmüller,
Ralf B. Schäfer (2020). webchem: An R Package to Retrieve Chemical
Information from the Web. Journal of Statistical Software, 93(13).
\doi{10.18637/jss.v093.i13}.
}
