% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panet_control.R
\name{+.rpactl}
\alias{+.rpactl}
\title{Add components to the control list}
\usage{
\method{+}{rpactl}(e1, e2)
}
\arguments{
\item{e1}{A list of class \code{rpactl}.}

\item{e2}{A list of class \code{rpactl}.}
}
\value{
A list of class \code{rpactl} with components from
  \code{e1} and \code{e2}.
}
\description{
`+` is used to combine components to control the PA network generation
process. Available components are \code{rpactl.scenario()},
\code{rpactl.edgeweight()}, \code{rpactl.newedge()},
\code{rpactl.preference()} and \code{rpactl.reciprocal()}.
}
\examples{
control <- rpactl.scenario(alpha = 0.5, beta = 0.5) +
    rpactl.preference(sparams = c(1, 1, 0, 0, 1),
        tparams = c(0, 0, 1, 1, 1))

control <- rpactl.scenario(alpha = 1) +
    rpactl.edgeweight(distribution = rgamma,
        dparams = list(shape = 5, scale = 0.2),
        shift = 1)
}
