% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveformgrid.R
\name{waveformgrid}
\alias{waveformgrid}
\title{waveformgrid}
\usage{
waveformgrid(hpc, waveform = NULL, geo = NULL, quan = NULL,
  res = c(0.8, 0.8), method = "HPC")
}
\arguments{
\item{hpc}{The hyper point cloud generated from the raw waveform data with hyperpointcloud function or
the data with the same structure as the hyperpointcloud object.}

\item{waveform}{The raw waveform data with only intensities.}

\item{geo}{The reference geolocation that corresponds to the raw waveform data which requres has the same row as the waveform data.
At least three colomns should be assigned: original x, y and first return reference bin location (fr,leading edge 50% point of the first return)).
You can see detailed description of the columns in geotransform.}

\item{quan}{The quantile of intenisty in the given grid or voxel. Defalut is NULL.}

\item{res}{The grid size with x and y spatial resolution. Default is 0.8*0.8, res=c(0.8,0.8).}

\item{method}{There are two methods c("HPC","Other") to project the waveforms into the 2d surface. Default ("HPC") is to use the HPC as the input data. The waveform and geo will be NULL.
"Other" is to use the raw waveform and corresponding reference geolcation data to generate the intensities in each grid, and hpc should be NULL.}
}
\value{
A dataframe with 7 columns including geolocation (center of the grid) and intensities. Specifically, these 7 columns are "index","cx","cy","length_maxi_meani_totali.1","length_maxi_meani_totali.2",
  "length_maxi_meani_totali.3","length_maxi_meani_totali.4").
  \item{index}{The index of the grid}
  \item{cx}{The mean x of the grid center }
  \item{cy}{The mean y of the grid center}
  \item{intensity.length or value.length}{The number of intensity in the grid. intensity.length is for the HPC method and value.intensity for the others}
  \item{intensity.maxi or value.maxi}{The maximum intensity of waveforms in the grid}
  \item{intensity.meani or value.meani}{The mean intensity of waveforms in the grid}
  \item{intensity.totali or value.totali}{The total intensity of waveforms in the grid}
  \item{...}{Percentile intensity based on the quan}
  By assigning differnt columns as x and y, the users can project waveforms into the xy, xz, yz surfaces.
}
\description{
The function allows you to project raw waveforms into 2d grids (can be xy, yz, and xz) with self defined resolution.
  For the values of each grid, four kinds of values were available to be used: the total number of intensity in each grid,
  maximum intensity of the grid, mean intensity of the grid, and total intensity of the grid.
}
\examples{

data(return)  ###import raw return waveforms
data(geo)  ###import corresponding reference geolocation
##if your geo data didn't the same column names as the follwoing one, you need to change it to
#it to the same column names. One thing you need to figure out is the corresponding column numbers
colnames(geo)[1:8]<-c("x","y","z","dx","dy","dz","or","fr")
###at least you should know which columns corresponding to x,y and fr before run the waveformgrid
##using the raw data
grid_re<-waveformgrid(waveform=return,geo=geo,res=c(0.8,0.8),method = "Other")

##using the hpc object
hpc<-hyperpointcloud(waveform=return,geo=geo)

hpcgrid<-waveformgrid(hpc=hpc,res=c(1,1))
}
\references{
Tan Zhou, Sorin Popescu, Lonesome Malambo, Kaiguang Zhao, Keith Krause. From LiDAR waveforms
  to Hyper Point Clouds: a novel data product to characterize vegetation structure.
  Remote Sensing 2018, 10(12), 1949; https://doi.org/10.3390/rs10121949
}
