% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_counts_one}
\alias{effect_counts_one}
\title{Test homogeneity of category shares}
\usage{
effect_counts_one(data, col, clean = TRUE, ...)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The column holding factor values.}

\item{clean}{Prepare data by \link{data_clean}}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_counts}.}
}
\value{
A volker tibble with the following statistical measures:
\itemize{
\item \strong{Gini coefficient}: Gini coefficient, measuring inequality.
\item \strong{n}: Number of cases the calculation is based on.
\item \strong{Chi-squared}: Chi-Squared test statistic.
\item \strong{p}: p-value for the statistical test.
\item \strong{stars}: Significance stars based on p-value (*, **, ***).
}
}
\description{
Performs a goodness-of-fit test and calculates the Gini coefficient.
The goodness-of-fit-test is calculated using \code{stats::\link[stats:chisq.test]{chisq.test}}.
}
\examples{
library(volker)
data <- volker::chatgpt

data |>
  filter(sd_gender != "diverse") |>
  effect_counts_one(sd_gender)

}
\keyword{internal}
