% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{Export 'vivainsights' outputs to CSV, clipboard, or save as images}
\usage{
export(
  x,
  method = "clipboard",
  path = "insights export",
  timestamp = TRUE,
  width = 12,
  height = 9
)
}
\arguments{
\item{x}{Data frame or 'ggplot' object to be passed through.}

\item{method}{Character string specifying the method of export.
Valid inputs include:
\itemize{
\item \code{"clipboard"} (default if input is data frame)
\item \code{"csv"}
\item \code{"png"} (default if input is 'ggplot' object)
\item \code{"svg"}
\item \code{"jpeg"}
\item \code{"pdf"}
}}

\item{path}{If exporting a file, enter the path and the desired file name,
\emph{excluding the file extension}. For example, \code{"Analysis/SQ Overview"}.}

\item{timestamp}{Logical vector specifying whether to include a timestamp in
the file name. Defaults to \code{TRUE}.}

\item{width}{Width of the plot}

\item{height}{Height of the plot}
}
\value{
A different output is returned depending on the value passed to the \code{method}
argument:
\itemize{
\item \code{"clipboard"}: no return - data frame is saved to clipboard.
\item \code{"csv"}: CSV file containing data frame is saved to specified path.
\item \code{"png"}: PNG file containing 'ggplot' object is saved to specified path.
\item \code{"svg"}: SVG file containing 'ggplot' object is saved to specified path.
\item \code{"jpeg"}: JPEG file containing 'ggplot' object is saved to specified path.
\item \code{"pdf"}: PDF file containing 'ggplot' object is saved to specified path.
}
}
\description{
A general use function to export 'vivainsights' outputs to CSV, clipboard, or save as
images. By default, \code{export()} copies a data frame to the clipboard. If the
input is a 'ggplot' object, the default behaviour is to export a PNG.
}
\seealso{
Other Import and Export: 
\code{\link{copy_df}()},
\code{\link{create_dt}()},
\code{\link{import_query}()},
\code{\link{prep_query}()}
}
\author{
Martin Chan \href{mailto:martin.chan@microsoft.com}{martin.chan@microsoft.com}
}
\concept{Import and Export}
